#include <bits/stdc++.h>
using namespace std;
using ll = int64_t;

vector<vector<int>> g;
vector<int> pa;
vector<int> c;
int n, q, u, v;

void dfs_pre(int s, int p){
    pa[s] = p;
    for(int e : g[s]){
        if(e!=p) dfs_pre(e, s);
    }
}

int dfs_calc(int s){
    int ret = 0;
    for(int e : g[s]){
        if(e!=pa[s]) ret += dfs_calc(e);
    }
    return ret + (c[s]!=c[pa[s]]);
}

void dfs_fill(int s, int x){
    for(int e : g[s]){
        if(e!=pa[s]) dfs_fill(e, x);
    }
    c[s] = x;
}

void solve1()
{
    dfs_pre(1, 0);
    while(q--){
        cin >> u >> v;
        dfs_fill(u, v);
        cout << dfs_calc(1) << '\n';
    }
}

vector<int> change;
vector<int> dp;
void dfs_gendp(int s){
    dp[s] = (c[s]!=c[pa[s]]);
    for(int e : g[s]){
        if(e!=pa[s]){
            dfs_gendp(e);
            dp[s] += dp[e];
        }
    }
}

int get_last_change(int ind){
    int ret = ind;
    for(int i=ind; i!=0; i=pa[i]){
        if(change[i] > change[ret]) ret = i;
    }
    return ret;
}


void solve2(){
    dfs_pre(1, 0);
    dp.resize(n+1);
    dfs_gendp(1);
    change.resize(n+1);
    fill(begin(change), end(change), -1);

    int a, b;
    for(int i=0; i<q; ++i){
        cin >> a >> b;
        int lc = get_last_change(a);
        int plc = get_last_change(pa[a]);
        int pc = (plc==-1 ? c[pa[a]] : c[plc]);
        int newdpi = (b!=pc ? 1 : 0);

        int diff = dp[lc] - newdpi - (lc!=a ? 1 : 0);
        for(int j=a; j!=0; j=pa[j]){
            dp[j] -= diff;
        }

        cout << dp[1] << '\n';
        change[a] = i;
        c[a] = b;
    }
}

bool is_linked(){
    int cnt1=0, cnt2=0;
    for(int i=1; i<=n; ++i){
        if(g[i].size()==1) ++cnt1;
        else if(g[i].size()==2) ++cnt2;
    }
    return cnt1==2 && cnt2==n-2;
}

void solve3(){
    stack<pair<int, int>> crls;
    crls.push({1, c[1]});
    for(int i=2; i<=n; ++i){
        if(crls.top().second != c[i]){
            crls.push({i, c[i]});
        }
    }

    int a, b;
    while(q--){
        cin >> a >> b;
        while(!crls.empty() && crls.top().first >= a) crls.pop();

        if(crls.empty() || crls.top().second != b){
            crls.push({a, b});
        }
        cout << crls.size() << '\n';
    }
}

int main(){
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);
    cin >> n >> q;
    g.resize(n+1);
    pa.resize(n+1);
    for(int i=0; i<n-1; ++i){
        cin >> u >> v;
        g[v].push_back(u);
        g[u].push_back(v);
    }
    
    c.resize(n+1);
    for(int i=1; i<=n; ++i) cin >> c[i];
    c[0] = -1;

    if(is_linked()) solve3();
    else if(q<=1000 && n<=1000) solve1();
    else solve2();
}